import * as net from "@minecraft/server-net";
import * as config from "./config";
/** Tries to retrieve bond token (only works up to ten minutes after power cycle.)
 * @returns Null indicates device unreachable / timeout, and undefined represents the bond denying the request.
 */ export async function tryGetToken() {
    let conf = config.getCurrentConfig();
    let req = new net.HttpRequest(`http://${conf.address}/v2/token`).setMethod(net.HttpRequestMethod.Get);
    let response;
    try {
        response = await net.http.request(req);
    } catch (e) {
        console.error(e);
        return null;
    }
    //Unauthorized (Likely too many attempts)
    if (response.status == 401) return undefined;
    if (response.status != 200 || !response.body) return null;
    let responseObject = JSON.parse(response.body);
    //Invalid response
    if (typeof responseObject != "object" || !('locked' in responseObject)) {
        return null;
    }
    //Access Denied baseically (Only accessible 10 minutes after bond startup.)
    if (responseObject.locked == 1 || !('token' in responseObject)) {
        return undefined;
    }
    return responseObject.token;
}
/** Test the current configuration
 * @returns HTTP resonse if unknown error
 */ export async function testConfig() {
    let conf = config.getCurrentConfig();
    let req = new net.HttpRequest(`http://${conf.address}/v2/devices`).setMethod(net.HttpRequestMethod.Get).addHeader("BOND-Token", conf.access_token);
    let response;
    try {
        response = await net.http.request(req);
    } catch (e) {
        return "Invalid IP";
    }
    if (response.status == 401) {
        return "Invalid Token";
    } else if (response.status == 200) {
        return "Sucess";
    }
    return response.status;
}
/** Sends a request to a particular enpoint
 * @param endpoint Do not include a starting /
 * @returns http response or undefined if timed out
 */ export async function sendRequest(endpoint, body) {
    let conf = config.getCurrentConfig();
    let req = new net.HttpRequest(`http://${conf.address}/${endpoint}`).setMethod(net.HttpRequestMethod.Get).addHeader("BOND-Token", conf.access_token);
    let response;
    try {
        response = await net.http.request(req);
    } catch (e) {
        return undefined;
    }
    return response;
}
